/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.ui.bonsai.config.TasksNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.AbstractTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.util.FilterResult;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import java.util.Iterator;
import java.util.Set;

public final class TasksTreeNode
extends AbstractTreeNode {
    private Set permittedRoles;

    protected TasksTreeNode(TasksTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected TasksTreeNode(TasksTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
        this.permittedRoles = clonee.permittedRoles;
    }

    public TasksTreeNode(TasksNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, parent, defaultWorkarea, filters, configBean.getKey());
    }

    public TasksTreeNode(TasksNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
        if (this.getTaskRetrieverKey() != null) {
            this.permittedRoles = this.getTaskRetriever().getPermittedUserRoles();
        }
    }

    public boolean isShown(UserObject userObj, boolean inTree) {
        boolean hasChildren;
        FilterResult filterResult = this.getFilterResult(userObj, inTree);
        if (filterResult.hasPriority() && filterResult.isFilteredOut()) {
            return false;
        }
        boolean hasTasks = false;
        if (this.permittedRoles != null) {
            Iterator i = userObj.getUserRoles().iterator();
            while (i.hasNext()) {
                if (!this.permittedRoles.contains(i.next())) continue;
                hasTasks = true;
                break;
            }
        }
        return (hasChildren = this.hasShownChildren(userObj)) || hasTasks && !filterResult.isFilteredOut();
    }

    public BonsaiTreeNode getCopy(BonsaiTreeNode parent, boolean copyChildren) {
        TasksTreeNode node = new TasksTreeNode(this, parent);
        if (copyChildren) {
            node.copyChildren(this);
        }
        return node;
    }
}

